/**
 * 
 */
package gov.va.med.mhv.usermgmt.jms;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;

/**
 * @author DNS
 *
 */
@Component
public class JmsMviTreatmentFacilityUpdator implements MviTreatmentFacilityUpdator {
	
	@Autowired
	@Qualifier("syncMviTreatmentFacilityUpdator")
	MviTreatmentFacilityUpdator synchronousMviTreatmentFacilityUpdator;

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator#updateTreatmentFacilitiesForExistingPatients(gov.va.med.mhv.common.data.model.Patient)
	 */
	@Override
	@JmsListener(destination = "jms/usermgmt/UPDATE_FACILITIES_Q", containerFactory = "jmsListenerContainerFactory")
	public void updateTreatmentFacilitiesForExistingPatients(PatientDTO patientDTO) throws MHVException {
		this.synchronousMviTreatmentFacilityUpdator.updateTreatmentFacilitiesForExistingPatients(patientDTO);
	}

}
